import PyBahn
from PyBahn import *

# Globale Konstanten 
HEIGHT = 900 # Fenstergröße
WIDTH = 920 # Fenstergröße
MARGIN = 20
CANVAS_HEIGHT = HEIGHT - MARGIN - 100
CANVAS_WIDTH = WIDTH - 2 * MARGIN
MY_FONT = 'Arial', 18

WIEDERHOLRATE = 50 # Simulationschritte pro Sekunde
DELTA_T_SIMULATION = int(1000 / WIEDERHOLRATE)

ANIMATION = True # Ein- und Ausschalten der Animation
ANIMATIONEN_PRO_SIMULATIONSSCHRITT = 5
DELTA_T_ANIMATION = DELTA_T_SIMULATION // ANIMATIONEN_PRO_SIMULATIONSSCHRITT

def schritt():
    global t_anim
    for _, zug in züge.items():
        zug.update()
    if ANIMATION:
        t_anim = 0        
        animiere()

def animiere():
    global t_anim
    for _, zug in züge.items():
        zug.animiere(t_anim)
    t_anim += 1
    if t_anim < ANIMATIONEN_PRO_SIMULATIONSSCHRITT:
        after_id = canvas.after(DELTA_T_ANIMATION, animiere)   

def start_stop():
    global läuft
    if läuft:
        läuft = False
        print('Zeit =', zeit)
    else:
        läuft = True
        laufe()
        
def laufe():
    global after_id, zeit, t_anim
    if not läuft:
        return

    if ANIMATION:                    
        if t_anim == 0:
            for _, zug in züge.items():
                zug.update()
            schalte_zufällig()
            zeit += 1     
                
        for _, zug in züge.items():
            zug.animiere(t_anim)
        t_anim = (t_anim + 1) % ANIMATIONEN_PRO_SIMULATIONSSCHRITT
        after_id = canvas.after(DELTA_T_ANIMATION, laufe)
    else:
        schalte_zufällig()
        schritt()
        after_id = canvas.after(DELTA_T_SIMULATION, laufe)

def schalte_zufällig():
    if random.random() > 0.95:
        print('Zeit =', zeit, 'Schalte alle Weichen um')
        schalte_um()        
    
def schalte_um():
    for _, weiche in weichen.items():
        if weiche.nach_links:
            weiche.schalte(False)
        else:
            weiche.schalte(True)
        
def umkehr():
    for _, zug in züge.items():
        zug.wechsle_richtung()


def erstelle_gleisbild():
    # Erstelle Oval
    starter = Starter(Vector(210, 390), 0)
    # erstes Geradenstück
    start = Gerade(starter, folgende=5)
    # erste Kurve
    s = neuestes_gleis()
    Kurve(s, False, 7)
    # zweites Geradenstück
    s = neuestes_gleis()
    abzweig_1 = s
    Gerade(s, folgende=5)  
    # zweite Kurve
    s = neuestes_gleis()
    Kurve(s, False, 3)
    abzweig_2 = neuestes_gleis()
    Kurve(abzweig_2, False, 3)
    # Kreis schließen
    kurve = neuestes_gleis()
    kurve.nachgelagert = start
    start.vorgelagert = kurve
    
    # Diagonale
    Kurve(abzweig_1, False, 2)
    s = neuestes_gleis()
    Gerade(s, folgende=1, length=LENGTH*0.95)
    s = neuestes_gleis()
    Kurve(s, True, 2)
    s = neuestes_gleis()
    s.nachgelagert = start # Anbindung
 
    # Untere Gesamtrunde
    Gerade(abzweig_2, folgende=4, length=LENGTH*0.929)  
    s = neuestes_gleis()
    Kurve(s, False, 3)
    s = neuestes_gleis()
    Gerade(s, folgende=5)
    s = neuestes_gleis()
    Kurve(s, False, 3)
    s = neuestes_gleis()
    Gerade(s, folgende=4, length=LENGTH*0.929)
    s = neuestes_gleis()
    s.nachgelagert = gleise[10]

    # Unterer Halbkreis
    s = Kurve(gleise[3], False, folgende=0, umgekehrt=True)
    gleise[3].nachgelagert = gleise[4]
    s.vorgelagert = gleise[4]
    Kurve(s, False, 6)
    s = neuestes_gleis()
    s.nachgelagert = gleise[49]
    
    # Definiere Weichen
    Weiche(12, 13, 28, 14)
    Weiche(27, 0, 35, 1)
    Weiche(22, 23, 24, 36)
    Weiche(11, 10, 59, 9)
    Weiche(5, 4, 60, 3)
    Weiche(50, 49, 48, 67)
    
    for _, weiche in weichen.items():
        print(weiche)
            
def main():
    # Erstelle das GUI
    global canvas
    window = tk.Tk()
    window.title('Modell-Eisenbahn 13')
    window.geometry(str(WIDTH) + 'x' + str(HEIGHT))
    window.resizable(0, 0)
    canvas = tk.Canvas(window, width=CANVAS_WIDTH, height=CANVAS_HEIGHT, bg='gray')
    canvas.place(x=MARGIN, y=MARGIN)

    button = tk.Button(window, text='Start/Stop', font=MY_FONT, command=start_stop)
    button.place(x=MARGIN, y=HEIGHT - 3*MARGIN)
    
    button = tk.Button(window, text='Schritt', font=MY_FONT, command=schritt)
    button.place(x=MARGIN + 150, y=HEIGHT - 3*MARGIN)
    
    button = tk.Button(window, text='Schalte', font=MY_FONT, command=schalte_um)
    button.place(x=MARGIN + 300, y=HEIGHT - 3*MARGIN)

    button = tk.Button(window, text='Umkehr', font=MY_FONT, command=umkehr)
    button.place(x=MARGIN + 450, y=HEIGHT - 3*MARGIN)

    button = tk.Button(window, text='Zeige Gleise', font=MY_FONT, command=zeige_gleise)
    button.place(x=MARGIN + 600, y=HEIGHT - 3*MARGIN)

    # Exportiere globale Variablen
    PyBahn.canvas = canvas
    PyBahn.ANIMATION = ANIMATION
    PyBahn.ANIMATIONEN_PRO_SIMULATIONSSCHRITT = ANIMATIONEN_PRO_SIMULATIONSSCHRITT
    
    erstelle_gleisbild()
    for i, s in gleise.items():
        s.zeichne(False)
        # print(i, ':', s)
        
    Zug('magenta', 5, 0)
    Zug('yellow', 4, 11)
    Zug('lime', 3, 45)
    
    for _, zug in züge.items():
        print(zug)
    
    window.mainloop()
    canvas.after_cancel(after_id)   

main()
